function[timeFPS, x_cargoFPS, Vfps] = PlotFPS(x_cargoRAW, timestampRAW, nruns, fps, Velwinsize, NoisePSF)

winsize = 1/fps; % convert FPS to win size in sec
VelwinFP = fix(Velwinsize/winsize); % # of frames for velocity calculation

% storage for output data
timeFPS = cell(nruns, 1);
x_cargoFPS = cell(nruns, 1);
Vfps = [];
tempVfps = cell(nruns, 1);

parfor ii = 1:nruns
%     Tavgrecord = 0;
    Cavgrecord = 0;
    tempTP = timestampRAW{ii};
    tempCP = x_cargoRAW{ii};
    nTP = length(tempTP);
    indexTP0 = 1;
    TP0 = tempTP(indexTP0);

    for jj = 1:nTP
        if (tempTP(jj) - TP0) > winsize
            Jend = jj - 1;
%             Tavgrecord = [Tavgrecord; mean(tempTP(indexTP0:Jend))];
            Cavgrecord = [Cavgrecord; mean(tempCP(indexTP0:Jend))];

            indexTP0 = Jend;
            TP0 = TP0 + winsize;
        end
    end
    % PSF noise
    SD_PSF = 8; % nm, standard deviation of PSF
    PSF_noise = normrnd(0, SD_PSF, size(Cavgrecord));
    if NoisePSF == 1
        Cavgrecord = Cavgrecord + PSF_noise;
    end
    Tavgrecord = ((1:length(Cavgrecord)) - 1)'*winsize;

    timeFPS{ii} = Tavgrecord;
    x_cargoFPS{ii} = Cavgrecord;

    indexVel0 = 1;
    while (indexVel0 + VelwinFP) <= length(Cavgrecord)
        indexVelEnd = indexVel0 + VelwinFP;

        Vtrend = polyfit(Tavgrecord(indexVel0:indexVelEnd), Cavgrecord(indexVel0:indexVelEnd), 1); % calculate slope of trendline as instantaneous velocity
        tempVfps{ii} = [tempVfps{ii}, Vtrend(1)];

        indexVel0 = indexVelEnd
    end
end

for kk = 1:nruns % make all instantaneous velocity from each run into a vector
    Vfps = [Vfps, tempVfps{kk}];
end

figure(1)
hold on
histogram(Vfps, 'BinWidth', 10, 'Normalization', 'pdf', 'DisplayStyle', 'stair', 'LineWidth', 1.5)
xlim([-300 300])
xlabel('Instantaneous Velocity (nm/s)')
ylabel('PDF')